<?php
// API JSON Response
if (isset($_GET['subscribers']) && isset($_GET['level'])) {
    header('Content-Type: application/json');
    $subs = (int) $_GET['subscribers'];
    $level = (int) $_GET['level'];

    if ($subs < 1 || $level < 1 || $level > 100) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Invalid parameters. Use ?subscribers=XXX&level=1-100',
            'credit' => 'API Made By Rx Hoster'
        ]);
        exit;
    }

    $C = floor($subs / 250) + 1;
    if ($level >= 1 && $level <= 8) {
        $boosts = ceil(($C * $level) / 2);
    } elseif ($level === 9) {
        $boosts = $C * 7;
    } else {
        $boosts = $C * $level;
    }

    echo json_encode([
        'status' => 'success',
        'subscribers' => $subs,
        'level' => $level,
        'boosts_needed' => $boosts,
        'credit' => 'API Made By Rx Hoster'
    ]);
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" />
  <title>Telegram Boost Level Calculator</title>
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap');
    * { box-sizing: border-box; }
    body {
      font-family: 'Poppins', Arial, sans-serif;
      background: #121212;
      color: #e0e0e0;
      padding: 40px 20px;
      max-width: 700px;
      margin: 0 auto;
    }
    h1 {
      text-align: center;
      font-weight: 600;
      margin-bottom: 30px;
      color: #00ffa5;
      text-shadow: 0 0 8px #00ffa5a0;
      user-select: none;
    }
    label {
      font-weight: 600;
      font-size: 0.95rem;
      color: #a0ffa0;
    }
    input, select {
      width: 100%;
      padding: 14px 16px;
      margin: 10px 0 20px;
      border-radius: 12px;
      border: 2px solid #222;
      background: #1c1c1c;
      color: #d0f0d0;
      font-size: 1.1rem;
      font-weight: 500;
      user-select: none;
    }
    input:focus, select:focus {
      outline: none;
      border-color: #00ffa5;
      box-shadow: 0 0 12px #00ffa5;
      background: #131313;
      color: #00ffa5;
    }
    .result {
      user-select: none;
      background: #1e1e1e;
      border-radius: 15px;
      padding: 25px 30px;
      box-shadow: 0 0 12px #00ffa5aa;
      font-size: 1.2rem;
      line-height: 1.5;
      color: #00ffa5;
      text-align: center;
      min-height: 90px;
    }
    .result strong {
      color: #a0ffba;
    }
    canvas {
      margin-top: 30px;
      background: #1a1a1a;
      border-radius: 15px;
      padding: 10px;
      display: block;
      max-width: 100%;
      height: auto;
    }
    @media (max-width: 480px) {
      .result { font-size: 1rem; padding: 20px; }
      canvas { width: 100% !important; height: auto !important; }
    }
    .api-doc-link {
      display: block;
      margin: 25px auto 0;
      max-width: 140px;
      text-align: center;
      padding: 8px 12px;
      background: #00ffa5;
      color: #000;
      font-weight: 600;
      border-radius: 10px;
      text-decoration: none;
      user-select: none;
      transition: background-color 0.3s ease;
      font-size: 0.9rem;
    }
    .api-doc-link:hover {
      background: #00cc86;
    }
    footer {
      margin-top: 25px;
      text-align: center;
      color: #888;
      font-size: 13px;
      font-weight: 400;
      user-select: none;
      font-family: 'Poppins', Arial, sans-serif;
      letter-spacing: 0.5px;
    }
  </style>
</head>
<body>
  <h1>Telegram Boost Level Calculator</h1>
  <label for="subs">Channel Subscribers:</label>
  <input type="number" id="subs" placeholder="Enter subscriber count" oninput="calculateBoosts()" min="1" />

  <label for="level">Target Boost Level:</label>
  <select id="level" onchange="calculateBoosts()"></select>

  <div class="result" id="result">Please enter subscriber count and select level.</div>

  <canvas id="boostChart" width="700" height="300"></canvas>

  <a href="boost-api-doc.php" class="api-doc-link" target="_blank" rel="noopener">📄 View API Documentation</a>

  <footer>
    &copy; 2025 Rx Hoster — All Rights Reserved
  </footer>

  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script>
    const levelSelect = document.getElementById("level");
    const levels = Array.from({ length: 100 }, (_, i) => i + 1);

    levels.forEach((level) => {
      const opt = document.createElement("option");
      opt.value = level;
      opt.innerText = `Level ${level}`;
      levelSelect.appendChild(opt);
    });

    let boostChart;

    function updateBoostChart(subs, targetLevel) {
      const C = Math.floor(subs / 250) + 1;
      const boostData = levels.map(lvl => {
        if (lvl >= 1 && lvl <= 8) return Math.ceil((C * lvl) / 2);
        else if (lvl === 9) return C * 7;
        else return C * lvl;
      });

      const ctx = document.getElementById('boostChart').getContext('2d');
      if (boostChart) boostChart.destroy();

      // Gradient fill for the chart
      const gradient = ctx.createLinearGradient(0, 0, 0, 300);
      gradient.addColorStop(0, 'rgba(0, 255, 165, 0.5)');
      gradient.addColorStop(1, 'rgba(0, 255, 165, 0.05)');

      // Highlight selected level point
      const pointRadiusArr = boostData.map((_, idx) => (levels[idx] === targetLevel ? 7 : 0));

      boostChart = new Chart(ctx, {
        type: 'line',
        data: {
          labels: levels.map(l => "L" + l),
          datasets: [{
            label: 'Boosts Needed',
            data: boostData,
            borderColor: '#00ffa5',
            backgroundColor: gradient,
            fill: true,
            tension: 0.3,
            pointRadius: pointRadiusArr,
            pointBackgroundColor: '#00ffa5',
            pointHoverRadius: 9,
            pointHoverBackgroundColor: '#00cc86',
          }]
        },
        options: {
          responsive: true,
          interaction: {
            mode: 'nearest',
            intersect: false,
          },
          plugins: {
            legend: { labels: { color: '#ccc' } },
            tooltip: {
              callbacks: {
                label: ctx => ` ${ctx.parsed.y} Boosts`,
                title: ctx => `Level ${levels[ctx[0].dataIndex]}`
              }
            }
          },
          scales: {
            x: { ticks: { color: '#ccc' } },
            y: { ticks: { color: '#ccc' }, beginAtZero: true }
          }
        }
      });
    }

    function calculateBoosts() {
      const subs = parseInt(document.getElementById("subs").value);
      const level = parseInt(levelSelect.value);
      const resultBox = document.getElementById("result");

      if (isNaN(subs) || subs < 1 || isNaN(level)) {
        resultBox.innerHTML = "Please enter valid values above.";
        return;
      }

      const C = Math.floor(subs / 250) + 1;
      let boostsNeeded;
      if (level >= 1 && level <= 8) {
        boostsNeeded = Math.ceil((C * level) / 2);
      } else if (level === 9) {
        boostsNeeded = C * 7;
      } else {
        boostsNeeded = C * level;
      }

      resultBox.innerHTML = `
        <strong>Subscribers:</strong> ${subs}<br>
        <strong>Target Level:</strong> ${level}<br>
        <strong>Boosts Needed:</strong> ${boostsNeeded}
      `;

      updateBoostChart(subs, level);
    }
  </script>
</body>
</html>
