<?php
function checkAdminAuth() {
    if (!isset($_SESSION['admin_logged_in'])) {
        header('Location: index.php');
        exit;
    }
}

function getUserData($userId) {
    global $pdo;
    
    $stmt = $pdo->prepare("SELECT * FROM users WHERE telegram_id = ?");
    $stmt->execute([$userId]);
    return $stmt->fetch();
}

function createUser($userId) {
    global $pdo;
    
    // Generate referral code
    $referralCode = substr(md5(uniqid($userId, true)), 0, 10);
    
    $stmt = $pdo->prepare("
        INSERT INTO users (telegram_id, referral_code) 
        VALUES (?, ?)
    ");
    $stmt->execute([$userId, $referralCode]);
    
    return getUserData($userId);
}

function getSystemSettings() {
    global $pdo;
    
    $stmt = $pdo->query("SELECT * FROM system_settings ORDER BY id DESC LIMIT 1");
    return $stmt->fetch() ?: [];
}

function updateUserAdsCount($userId, $newCount) {
    global $pdo;
    
    $stmt = $pdo->prepare("UPDATE users SET total_ads_watched = ? WHERE telegram_id = ?");
    $stmt->execute([$newCount, $userId]);
}

function updateUserBalance($userId, $newBalance) {
    global $pdo;
    
    $stmt = $pdo->prepare("UPDATE users SET balance = ? WHERE telegram_id = ?");
    $stmt->execute([$newBalance, $userId]);
}

function logAdWatch($userId, $amount) {
    global $pdo;
    
    $stmt = $pdo->prepare("INSERT INTO ads_watched (user_id, reward_amount) VALUES (?, ?)");
    $stmt->execute([$userId, $amount]);
}

function getReferredCount($userId) {
    global $pdo;
    
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM users WHERE referred_by = ?");
    $stmt->execute([$userId]);
    return $stmt->fetchColumn();
}

function createWithdrawalRequest($userId, $amount, $wallet) {
    global $pdo;
    
    $stmt = $pdo->prepare("
        INSERT INTO rewards (user_id, amount, wallet_address) 
        VALUES (?, ?, ?)
    ");
    $stmt->execute([$userId, $amount, $wallet]);
}

function getAllUsers() {
    global $pdo;
    
    $stmt = $pdo->query("SELECT * FROM users ORDER BY created_at DESC");
    return $stmt->fetchAll();
}

function getWithdrawalRequests() {
    global $pdo;
    
    $stmt = $pdo->query("
        SELECT r.*, u.first_name, u.username 
        FROM rewards r
        JOIN users u ON r.user_id = u.telegram_id
        ORDER BY r.claimed_at DESC
    ");
    return $stmt->fetchAll();
}

function getRecentAdLogs($limit = 50) {
    global $pdo;
    
    $stmt = $pdo->prepare("
        SELECT a.*, u.first_name, u.username 
        FROM ads_watched a
        JOIN users u ON a.user_id = u.telegram_id
        ORDER BY a.watched_at DESC
        LIMIT ?
    ");
    $stmt->execute([$limit]);
    return $stmt->fetchAll();
}

function getUserName($userId) {
    global $pdo;
    
    $stmt = $pdo->prepare("SELECT first_name, username FROM users WHERE telegram_id = ?");
    $stmt->execute([$userId]);
    $user = $stmt->fetch();
    
    if ($user) {
        return $user['first_name'] . ($user['username'] ? ' (@' . $user['username'] . ')' : '');
    }
    
    return 'Unknown User';
}
?>