<?php
require_once __DIR__ . '/../config.php';

try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Create tables if they don't exist
$pdo->exec("
    CREATE TABLE IF NOT EXISTS users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        telegram_id BIGINT UNIQUE,
        username VARCHAR(255),
        first_name VARCHAR(255),
        last_name VARCHAR(255),
        balance DECIMAL(10,2) DEFAULT 0,
        total_ads_watched INT DEFAULT 0,
        referral_code VARCHAR(20) UNIQUE,
        referred_by INT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    );
    
    CREATE TABLE IF NOT EXISTS ads_watched (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT,
        ad_id VARCHAR(255),
        watched_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        reward_amount DECIMAL(10,2),
        FOREIGN KEY (user_id) REFERENCES users(id)
    );
    
    CREATE TABLE IF NOT EXISTS rewards (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT,
        amount DECIMAL(10,2),
        claimed_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        status ENUM('pending', 'processed', 'rejected') DEFAULT 'pending',
        FOREIGN KEY (user_id) REFERENCES users(id)
    );
    
    CREATE TABLE IF NOT EXISTS system_settings (
        id INT AUTO_INCREMENT PRIMARY KEY,
        min_ads_to_watch INT DEFAULT " . DEFAULT_MIN_ADS . ",
        monetag_script TEXT,
        reward_per_ad DECIMAL(10,2) DEFAULT " . DEFAULT_REWARD_PER_AD . ",
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    );
    
    CREATE TABLE IF NOT EXISTS admin_users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        username VARCHAR(255) UNIQUE,
        password_hash VARCHAR(255),
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );
    
    INSERT IGNORE INTO system_settings (id) VALUES (1);
    INSERT IGNORE INTO admin_users (username, password_hash) VALUES ('" . ADMIN_USERNAME . "', '" . ADMIN_PASSWORD_HASH . "');
");
?>